#!/bin/bash
#Sysadmin utility to verify their SSH files integrity
#

VER="1.0.0"

MD5=/usr/bin/md5sum
SHA1=/usr/bin/sha1sum
#List of protected files
PROTECTED="/usr/sbin/sshd /usr/bin/ssh* $MD5 $SHA1"
#MD5 and SHA1 checksum base
MD5BASE="/root/MD5.base"
SHA1BASE="/root/SHA1.base"

if [ -z $1 ]
then
 echo "Usage    : $0 <opetions>"
 echo "Options  :"
 echo "lock     - set immutable bit"
 echo "open     - unset immutable bit"
 echo "create   - create md5sum dan sha1sum"
 echo "check    - check md5sum dan sha1sum"
 echo
 exit
fi

###
#You have to run this checker after installing OpenSSH
#lock   : lock all SSH files with immutable bit
#create : create MD5 and SHA1 checksum for all SSH files
###
#You also have to run this checker regularly
#check  : check MD5 and SHA1 checksum for all SSH files
###
#open   : if you wan to upgrade or re-install OpenSSH
###

case $1 in
 "lock")
  chattr +i $PROTECTED
 ;;
 "open")
  chattr -i $PROTECTED
 ;;
 "create")
  $MD5 $PROTECTED > $MD5BASE
  chattr +i $MD5BASE
  $SHA1 $PROTECTED > $SHA1BASE
  chattr +i $SHA1BASE
 ;;
 "check")
  $MD5 -c $MD5BASE
  $SHA1 -c $SHA1BASE
 ;;
*)
  echo "ERROR! unknown option"
 ;;
esac
